/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.misc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;
import org.metabit.tools.games.lrctf.logs.LogEntryHelper;
import org.metabit.tools.games.lrctf.logs.MatchCollection;
import org.metabit.tools.games.lrctf.stats.MatchResult;

public class StatsCalculator {
    Vector perMatch_slotData = new Vector();

    public void evaluateMatches(MatchCollection mc) throws IOException {
        File f = new File("matches.html");
        FileWriter fw = new FileWriter(f);
        fw.write("<style>\n");
        fw.write("Table.matchT { background-color: black; color: white }\n");
        fw.write("</style>\n");
        Iterator it = mc.iterator();
        while (it.hasNext()) {
            LRCTFMatch match = (LRCTFMatch)it.next();
            this.evaluateSingleMatch(match, fw);
        }
        fw.flush();
    }

    public void evaluateSingleMatch(LRCTFMatch match, Writer out) throws IOException {
        LRCTFLogEntry entry;
        Iterator it = match.iterator();
        MatchResult mr = new MatchResult();
        mr.readFromLog(it);
        if (mr.hasSlotEntries()) {
            out.write("<hr><div>" + match.toString());
            out.write("<div>playing map: " + match.getSettings().getProperty("mapname", null) + "</div>\n");
            out.write(mr.toHTMLTable());
            out.write("</div>");
        }
        it = match.iterator();
        while (it.hasNext()) {
            entry = (LRCTFLogEntry)it.next();
            this.processEntry(entry);
        }
        it = match.iterator();
        while (it.hasNext()) {
            entry = (LRCTFLogEntry)it.next();
        }
    }

    public int processEntry(LRCTFLogEntry entry) {
        int key = entry.getKey();
        int player = entry.getData(LRCTFLogEntry.D_PLAYER);
        String text = entry.getText();
        switch (key) {
            case 1: {
                this.perMatch_clearSlotNames();
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                System.out.println(entry);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                Properties prop = LogEntryHelper.parseUserinfoChangeText(text);
                String playerName = prop.getProperty("n", null);
                this.perMatch_setSlotName(player, playerName);
                this.perMatch_setSlotUserinfo(player, prop);
                break;
            }
            case 14: {
                String playerName = this.perMatch_getSlotName(player);
                System.out.println("CAPTURE! (#" + player + ") " + playerName);
                break;
            }
        }
        return 0;
    }

    protected void perMatch_clearSlotNames() {
        this.perMatch_slotData = new Vector();
    }

    protected void perMatch_setSlotName(int slot, String name) {
        ClientData client = this.getOrCreateSlotEntry(slot);
        client.nameAssign(name);
    }

    protected String perMatch_getSlotName(int slot) {
        ClientData client = this.getOrCreateSlotEntry(slot);
        return client.getCurrentName();
    }

    protected void perMatch_setSlotUserinfo(int slot, Properties prop) {
        ClientData client = this.getOrCreateSlotEntry(slot);
        client.clientInfo = prop;
    }

    protected ClientData getOrCreateSlotEntry(int slot) {
        ClientData client;
        if (slot >= this.perMatch_slotData.size()) {
            this.perMatch_slotData.setSize(slot + 1);
        }
        if ((client = (ClientData)this.perMatch_slotData.get(slot)) == null) {
            client = new ClientData(slot);
            this.perMatch_slotData.setElementAt(client, slot);
        }
        return client;
    }

    class ClientData {
        public int slotNumber = 0;
        public String currentName = null;
        public Properties clientInfo = null;
        public Vector nameHistory = new Vector();

        public ClientData(int slot) {
            this.slotNumber = slot;
        }

        public void nameAssign(String name) {
            this.nameHistory.addElement(name);
            this.currentName = name;
        }

        public final String getCurrentName() {
            return this.currentName;
        }
    }
}

