/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.logs;

import com.metabit.naming.util.SimpleNameContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metabit.tools.games.lrctf.Constants;

public class PBLogParser {
    static SimpleNameContext PBkeywords = null;
    private static final Pattern newconnectionPattern = Pattern.compile("\\s*New Connection \\(slot #(\\d+)\\)\\s+(\\S+)\\s+(.*)");
    private static final Pattern playerGUIDPattern = Pattern.compile("\\s*Player GUID Computed ([0-9a-f]+)\\(\\-\\) \\(slot #(\\d+)\\)\\s+(\\S+)\\s+(.*)");
    private static final Pattern GUIDAUTHPattern = Pattern.compile("\\s*GUID AUTH:\\s+([0-9a-f]+)\\s+(.*)");
    private static final Pattern localCheckPattern = Pattern.compile("\\[From #(\\d+) ([0-9a-f]+)\\((.*)\\) (.*) My gl (.*) size=(\\d+) md5=([0-9a-f]+)\\s*");
    int internalMatchNumber = 0;
    SimpleNameContext guidLUT = new SimpleNameContext();
    Vector slotLUT = new Vector();
    Map guidNameMapping = new LinkedHashMap();
    Map nameGUIDMapping = new LinkedHashMap();

    public PBLogParser() {
        if (PBkeywords == null) {
            PBkeywords = new SimpleNameContext();
            Constants.initPBKeywords(PBkeywords);
        }
    }

    public void parseStream(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is);
        LineNumberReader in = new LineNumberReader(isr);
        Matcher newconn = newconnectionPattern.matcher("");
        Matcher playerGUID = playerGUIDPattern.matcher("");
        Matcher guidAuth = GUIDAUTHPattern.matcher("");
        while (in.ready()) {
            String line = in.readLine();
            int idx = line.indexOf(58);
            if (idx < 0) continue;
            String firstPart = line.substring(0, idx);
            String secondPart = line.substring(idx + 1);
            int id = PBkeywords.lookupID(firstPart);
            switch (id) {
                default: {
                    break;
                }
                case 83: {
                    this.event_InitGame(secondPart);
                    break;
                }
                case 84: {
                    this.event_ShutdownGame(secondPart);
                    break;
                }
                case 70: {
                    int slotNr;
                    newconn.reset(secondPart);
                    playerGUID.reset(secondPart);
                    guidAuth.reset(secondPart);
                    if (newconn.matches()) {
                        slotNr = Integer.parseInt(newconn.group(1));
                        this.event_NewConnection(slotNr, newconn.group(2), newconn.group(3));
                        break;
                    }
                    if (playerGUID.matches()) {
                        slotNr = Integer.parseInt(playerGUID.group(2));
                        this.event_PlayerGUIDComputed(playerGUID.group(1), slotNr, playerGUID.group(3), playerGUID.group(4));
                        break;
                    }
                    if (!guidAuth.matches()) break;
                    this.event_GUID_AUTH(guidAuth.group(1), guidAuth.group(2));
                }
                case 75: 
            }
        }
        in.close();
        isr.close();
        Set entries = this.guidNameMapping.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            System.out.println("GUID:" + me.getKey() + " => " + me.getValue());
        }
    }

    protected void event_InitGame(String s) {
        ++this.internalMatchNumber;
    }

    protected void event_ShutdownGame(String s) {
    }

    protected void event_NewConnection(int slotNr, String ip_port, String playerName) {
    }

    protected void event_PlayerGUIDComputed(String guid, int slotNr, String ip_port, String playerName) {
        String chkGUID;
        String chkname;
        int id = this.guidLUT.getOrAddString(guid);
        if (this.guidNameMapping.containsValue(playerName) && (chkname = (String)this.guidNameMapping.get(guid)).compareTo(playerName) != 0) {
            System.out.println("ID collision between " + playerName + " and " + chkname + " for same GUID.");
        }
        if (this.nameGUIDMapping.containsKey(playerName) && (chkGUID = (String)this.nameGUIDMapping.get(playerName)).compareTo(guid) != 0) {
            System.out.println("GUID collision for " + playerName + " between " + chkGUID + " and new " + guid + " - possibly nick stealing.");
        }
        this.guidNameMapping.put(guid, playerName);
        this.nameGUIDMapping.put(playerName, guid);
    }

    protected void event_GUID_AUTH(String guid, String validity) {
    }
}

