/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.logs;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;

public class MatchCollection
implements Collection {
    private SortedSet matches;

    public MatchCollection() {
        this.matches = new TreeSet();
    }

    public MatchCollection(SortedSet contents) {
        this.matches = contents;
    }

    public boolean addMatch(LRCTFMatch match) {
        if (match == null) {
            return false;
        }
        return this.matches.add(match);
    }

    public MatchCollection getSubset(Date earliest, Date latest) {
        LRCTFMatch tmp;
        LRCTFMatch first = null;
        LRCTFMatch last = null;
        Iterator it = this.matches.iterator();
        while (it.hasNext()) {
            tmp = (LRCTFMatch)it.next();
            if (earliest.compareTo(tmp.getMatchStart()) > 0) continue;
            first = tmp;
            break;
        }
        if (first == null) {
            return null;
        }
        while (it.hasNext() && latest.compareTo((tmp = (LRCTFMatch)it.next()).getMatchStart()) >= 0) {
            last = tmp;
        }
        if (last == null) {
            return null;
        }
        return new MatchCollection(this.matches.subSet(first, last));
    }

    public MatchCollection getSubset(Date earliest, long delta) {
        Date latest = new Date(earliest.getTime() + delta);
        return this.getSubset(earliest, latest);
    }

    public MatchCollection getDaySubset(int year, int month, int day) {
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        Date from = gc.getTime();
        gc.add(5, 1);
        Date until = gc.getTime();
        return this.getSubset(from, until);
    }

    public MatchCollection getWeekSubset(int year, int month, int day) {
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        Date from = gc.getTime();
        gc.add(5, 7);
        Date until = gc.getTime();
        return this.getSubset(from, until);
    }

    public MatchCollection getMonthSubset(int year, int month, int day) {
        GregorianCalendar gc = new GregorianCalendar(year, month - 1, day);
        Date from = gc.getTime();
        gc.add(2, 1);
        Date until = gc.getTime();
        return this.getSubset(from, until);
    }

    public void printOut(PrintStream out) {
        Iterator it = this.matches.iterator();
        out.println("----- Match collection start -----");
        while (it.hasNext()) {
            LRCTFMatch m = (LRCTFMatch)it.next();
            out.println(m.toString());
        }
        out.println("------ Match collection end ------");
    }

    public boolean add(Object o) {
        return this.addMatch((LRCTFMatch)o);
    }

    public final void clear() {
        this.matches.clear();
    }

    public final boolean contains(Object o) {
        return this.matches.contains(o);
    }

    public final boolean containsAll(Collection c) {
        return this.matches.containsAll(c);
    }

    public final boolean equals(Object o) {
        return this.matches.equals(o);
    }

    public final int hashCode() {
        return this.matches.hashCode();
    }

    public final boolean remove(Object o) {
        return this.matches.remove(o);
    }

    public final Object[] toArray() {
        return this.matches.toArray();
    }

    public final Object[] toArray(Object[] a) {
        return this.matches.toArray(a);
    }

    public final boolean addAll(Collection c) {
        return this.matches.addAll(c);
    }

    public final boolean removeAll(Collection c) {
        return this.matches.removeAll(c);
    }

    public final boolean retainAll(Collection c) {
        return this.matches.retainAll(c);
    }

    public final boolean isEmpty() {
        return this.matches.isEmpty();
    }

    public final int size() {
        return this.matches.size();
    }

    public final Iterator iterator() {
        return this.matches.iterator();
    }
}

