/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.logs;

import com.metabit.naming.util.SimpleNameContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metabit.tools.games.lrctf.Constants;
import org.metabit.tools.games.lrctf.logs.LRCTFLogEntry;
import org.metabit.tools.games.lrctf.logs.LRCTFMatch;

public class LRCTFLogParser {
    public static String SEPARATORLINE = "------------------------------------------------------------";
    private static Pattern timePattern = Pattern.compile("\\s*(\\d+):(\\d\\d)\\s*");
    private static Pattern buggyTimePattern = Pattern.compile("\\s*(\\d+):*(\\d*)\\s*");
    private static Pattern killPattern = Pattern.compile("\\s*(\\d+)\\s+(\\d+)\\s+(\\d+):(.*)");
    private static Pattern killPatternSub = Pattern.compile("\\s*(.+) killed (.+) by (.+)");
    private static Pattern scorePattern = Pattern.compile("\\s*(-?\\d+)\\s+ping:\\s*(\\d+)\\s+client:\\s*(\\d+)\\s+(.*)");
    private static Pattern mvpPattern = Pattern.compile("\\s*client:\\s*(\\d+)\\s*defense:\\s*(\\d+)\\s*offense:\\s*(\\d+)\\s*frags:\\s*(\\d+)\\s*name:\\s*(.*)");
    private static Pattern excellentPtrn = Pattern.compile("\\s*(\\d+)\\s*(\\d+)\\s*(\\d+)\\s*");
    private static Pattern rbPattern = Pattern.compile("(\\d+)\\s*blue:(\\d+)\\s*");
    private static Pattern tellPattern = Pattern.compile("\\s*(.+) to (.+): (.*)");
    private static int MAXWEAPON = Constants.getWeaponCount();
    private static SimpleNameContext deathReasons = null;
    private static SimpleNameContext keywords = null;
    private static SimpleNameContext itemNames = null;
    private InputStreamReader isr;
    private LineNumberReader in;
    private LinkedList playerInfos;

    public LRCTFLogParser(InputStream ins) {
        if (deathReasons == null) {
            deathReasons = new SimpleNameContext();
            Constants.initDeathReasons(deathReasons);
        }
        if (keywords == null) {
            keywords = new SimpleNameContext();
            Constants.initKeywords(keywords);
        }
        if (itemNames == null) {
            itemNames = new SimpleNameContext();
            Constants.initItems(itemNames);
        }
        this.isr = new InputStreamReader(ins);
        this.in = new LineNumberReader(this.isr);
        this.playerInfos = new LinkedList();
    }

    public void finalize() {
        if (this.playerInfos != null) {
            this.playerInfos.clear();
            this.playerInfos = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.isr != null) {
            this.isr = null;
        }
    }

    public Object singlePassParseMatch() throws IOException {
        if (!this.in.ready()) {
            return null;
        }
        LRCTFMatch match = null;
        LinkedList<LRCTFLogEntry> entries = new LinkedList<LRCTFLogEntry>();
        boolean loopflag = true;
        boolean atstart = true;
        block6: while (this.in.ready() && loopflag) {
            String line = this.in.readLine();
            LRCTFLogEntry entry = this.processLineToEntry(line);
            if (entry == null) continue;
            entries.add(entry);
            switch (entry.getKey()) {
                case 3: {
                    match = new LRCTFMatch(entries);
                    loopflag = false;
                    if (entries.size() <= 0) continue block6;
                    System.err.println("match not completely parsed");
                    continue block6;
                }
                case 1: {
                    if (!atstart) {
                        System.err.println("match start seems skewed here");
                        continue block6;
                    }
                    atstart = false;
                    continue block6;
                }
                case 0: {
                    System.err.println("not recognized:" + line);
                    continue block6;
                }
                case 63: {
                    continue block6;
                }
            }
            if (atstart) {
                System.err.println("BEFORE START:" + line);
            }
            atstart = false;
        }
        return match;
    }

    private LRCTFLogEntry processLineToEntry(String line) {
        try {
            LRCTFLogEntry entry = this.processLine(line);
            if (entry == null) {
                System.err.println("problem in parsing line #" + this.in.getLineNumber() + ", line reads:" + line);
                return null;
            }
            if (this.processLogEntry(entry, line)) {
                return entry;
            }
            System.err.println("problem in processing this line:\n" + line + " - still accepting that entry");
            return entry;
        }
        catch (ParseException pe2) {
            String s = "Parse Exception in line #" + this.in.getLineNumber() + ":\n";
            s = s + pe2.getLocalizedMessage() + '\n';
            s = s + "Line: " + line + '\n';
            System.err.println(s);
            Object pe2 = null;
            return new LRCTFLogEntry(-1, this.in.getLineNumber(), 95, s);
        }
    }

    public LRCTFLogEntry processLine(String line) throws ParseException {
        int hour = -1;
        int minute = -1;
        if (line.length() < 8) {
            return new LRCTFLogEntry(0, 0, 95, line);
        }
        String timeSnip = line.substring(0, 7);
        String rest = line.substring(7);
        Matcher timeMatcher = timePattern.matcher(timeSnip);
        Matcher timeMatcherFix = buggyTimePattern.matcher(timeSnip);
        if (timeMatcher.matches()) {
            hour = Integer.parseInt(timeMatcher.group(1));
            minute = Integer.parseInt(timeMatcher.group(2));
        } else if (timeMatcherFix.matches()) {
            hour = Integer.parseInt(timeMatcherFix.group(1));
            minute = Integer.parseInt(timeMatcherFix.group(2));
        } else {
            throw new ParseException("lines are expected to start with time stamp. '" + timeSnip + "' didn't match.", 0);
        }
        int idx = rest.indexOf(58);
        if (idx < 0) {
            if (SEPARATORLINE.compareTo(rest) == 0) {
                return new LRCTFLogEntry(hour, minute, 63, null);
            }
            throw new ParseException("could not parse this: '" + rest + "'", idx);
        }
        String keyword = rest.substring(0, idx);
        int key = keywords.lookupID(keyword);
        if (key <= 0) {
            throw new ParseException("KEYWORD NOT RECOGNIZED: " + keyword, idx);
        }
        return new LRCTFLogEntry(hour, minute, key, rest.substring(idx + 1));
    }

    public boolean processLogEntry(LRCTFLogEntry entry, String line) throws ParseException {
        int code = entry.getKey();
        PrintWriter out = new PrintWriter(System.out);
        switch (code) {
            case 0: {
                System.out.println("Bah! Key not recognized!\n" + line);
                return false;
            }
            case 1: {
                break;
            }
            case 6: {
                String text = entry.getText();
                StringTokenizer st = new StringTokenizer(text, " ");
                String t1 = st.nextToken();
                String t2 = st.nextToken();
                int pnum = Integer.parseInt(t1);
                entry.setData(LRCTFLogEntry.D_PLAYER, pnum);
                entry.setText(t2);
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (this.event_Exit(entry)) break;
                System.err.println(line);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                if (this.event_SingleParameterPlayer(entry)) break;
                System.err.println(entry.toString());
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                this.event_Kill(entry);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                this.event_Award(entry);
                break;
            }
            case 22: {
                LRCTFLogParser.event_Excellent(entry);
                break;
            }
            case 23: 
            case 24: {
                this.event_SingleParameterPlayer(entry);
                break;
            }
            case 25: {
                this.event_MVP_Points(entry);
                break;
            }
            case 26: {
                LRCTFLogParser.event_redblue(entry);
                break;
            }
            case 27: {
                this.event_Score(entry);
                break;
            }
            case 11: {
                this.event_Item(entry);
                break;
            }
            case 28: {
                this.event_tell(entry);
                break;
            }
            case 63: {
                break;
            }
            default: {
                System.out.println("This entry was not processed properly! ==>" + entry.toString());
            }
        }
        out.flush();
        return true;
    }

    protected boolean event_Exit(LRCTFLogEntry entry) {
        String text = entry.getText().trim();
        if (text.compareToIgnoreCase("Timelimit hit.") == 0) {
            entry.setData(LRCTFLogEntry.D_REASON, 1);
        } else if (text.compareToIgnoreCase("Capturelimit hit.") == 0) {
            entry.setData(LRCTFLogEntry.D_REASON, 2);
        } else {
            return false;
        }
        return true;
    }

    protected boolean event_SingleParameterPlayer(LRCTFLogEntry entry) {
        try {
            int pnum = Integer.parseInt(entry.getText().trim());
            entry.setData(LRCTFLogEntry.D_PLAYER, pnum);
            entry.setText(null);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    protected void event_Award(LRCTFLogEntry entry) throws ParseException {
        try {
            String text = entry.getText();
            StringTokenizer st = new StringTokenizer(text, " ");
            String t1 = st.nextToken();
            String t2 = st.nextToken();
            int pnum = Integer.parseInt(t1);
            entry.setData(LRCTFLogEntry.D_PLAYER, pnum);
            entry.setText(t2);
            return;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(nfe.getLocalizedMessage(), 0);
        }
    }

    protected static void event_Excellent(LRCTFLogEntry entry) throws ParseException {
        int client = -1;
        int ex1 = -1;
        int ex2 = -1;
        Matcher excellentMatcher = excellentPtrn.matcher(entry.getText());
        if (excellentMatcher.matches()) {
            client = Integer.parseInt(excellentMatcher.group(1));
            ex1 = Integer.parseInt(excellentMatcher.group(2));
            ex2 = Integer.parseInt(excellentMatcher.group(3));
            entry.setData(LRCTFLogEntry.D_PLAYER, client);
            entry.setData(LRCTFLogEntry.D_EX1, ex1);
            entry.setData(LRCTFLogEntry.D_EX2, ex2);
            entry.setText(null);
        } else {
            System.err.println("ERROR: SCORE not parsed :" + entry.toString());
        }
    }

    protected static void event_redblue(LRCTFLogEntry entry) throws ParseException {
        int red = -1;
        int blue = -1;
        Matcher rbMatcher = rbPattern.matcher(entry.getText());
        if (rbMatcher.matches()) {
            red = Integer.parseInt(rbMatcher.group(1));
            blue = Integer.parseInt(rbMatcher.group(2));
            entry.setData(LRCTFLogEntry.D_RED, red);
            entry.setData(LRCTFLogEntry.D_BLUE, blue);
            entry.setText(null);
        } else {
            System.err.println("ERROR: SCORE not parsed :" + entry.toString());
        }
    }

    protected void event_Score(LRCTFLogEntry entry) throws ParseException {
        int score = -1;
        int ping = -1;
        int client = -1;
        String name = null;
        Matcher scoreMatcher = scorePattern.matcher(entry.getText());
        if (scoreMatcher.matches()) {
            score = Integer.parseInt(scoreMatcher.group(1));
            ping = Integer.parseInt(scoreMatcher.group(2));
            client = Integer.parseInt(scoreMatcher.group(3));
            name = scoreMatcher.group(4);
            entry.setData(LRCTFLogEntry.D_SCORE, score);
            entry.setData(LRCTFLogEntry.D_PING, ping);
            entry.setData(LRCTFLogEntry.D_PLAYER, client);
            entry.setText(name);
            return;
        }
        System.err.println("ERROR: SCORE not parsed :" + entry.toString());
    }

    protected void event_MVP_Points(LRCTFLogEntry entry) throws ParseException {
        int client = -1;
        int offense = -1;
        int defense = -1;
        int frags = -1;
        String name = null;
        Matcher mvpMatcher = mvpPattern.matcher(entry.getText());
        if (mvpMatcher.matches()) {
            client = Integer.parseInt(mvpMatcher.group(1));
            defense = Integer.parseInt(mvpMatcher.group(2));
            offense = Integer.parseInt(mvpMatcher.group(3));
            frags = Integer.parseInt(mvpMatcher.group(4));
            name = mvpMatcher.group(5);
            entry.setData(LRCTFLogEntry.D_PLAYER, client);
            entry.setData(LRCTFLogEntry.D_DEFENSE, defense);
            entry.setData(LRCTFLogEntry.D_OFFENSE, offense);
            entry.setData(LRCTFLogEntry.D_FRAGS, frags);
            entry.setText(name);
            return;
        }
        System.err.println("ERROR: mvpPoints not parsed :" + entry.toString());
    }

    protected void event_Kill(LRCTFLogEntry entry) {
        int taeter = 0;
        int opfer = 0;
        int waffe = 0;
        String taeterS = null;
        String opferS = null;
        String waffeS = null;
        Matcher killMatcher = killPattern.matcher(entry.getText());
        if (killMatcher.matches()) {
            int wnum;
            taeter = Integer.parseInt(killMatcher.group(1));
            opfer = Integer.parseInt(killMatcher.group(2));
            waffe = Integer.parseInt(killMatcher.group(3));
            String rest = killMatcher.group(4);
            Matcher kill2Matcher = killPatternSub.matcher(rest);
            if (kill2Matcher.matches()) {
                taeterS = kill2Matcher.group(1);
                opferS = kill2Matcher.group(2);
                waffeS = kill2Matcher.group(3);
            }
            if (waffeS != null && (wnum = deathReasons.lookupID(waffeS)) != waffe) {
                System.err.println("REPORT: unknown weapon:" + waffe + " " + waffeS);
            }
            entry.setData(LRCTFLogEntry.D_PLAYER, taeter);
            entry.setData(LRCTFLogEntry.D_VICTIM, opfer);
            entry.setData(LRCTFLogEntry.D_WEAPON, waffe);
        } else {
            System.err.println("ERROR: KILL not parsed :" + entry.toString());
        }
    }

    protected boolean event_Item(LRCTFLogEntry entry) {
        String text = entry.getText();
        StringTokenizer st = new StringTokenizer(text, " ");
        String t1 = st.nextToken();
        String t2 = st.nextToken().trim();
        int pnum = Integer.parseInt(t1);
        entry.setData(LRCTFLogEntry.D_PLAYER, pnum);
        int itemcode = itemNames.lookupID(t2);
        if (itemcode >= 0) {
            entry.setData(LRCTFLogEntry.D_ITEMCODE, itemcode);
            entry.setText(null);
            return true;
        }
        System.err.println("Item not recognized: " + itemcode + " : " + t2 + " \t(" + entry.toString() + ")");
        entry.setData(LRCTFLogEntry.D_ITEMCODE, 0);
        entry.setText(t2);
        return false;
    }

    protected boolean event_tell(LRCTFLogEntry entry) {
        return true;
    }

    public List pass1() throws IOException {
        LinkedList<LRCTFLogEntry> entries = new LinkedList<LRCTFLogEntry>();
        while (this.in.ready()) {
            if (this.in.getLineNumber() % 1000 == 0) {
                // empty if block
            }
            String line = this.in.readLine();
            try {
                LRCTFLogEntry entry = this.processLine(line);
                if (entry == null) {
                    System.err.println("problem in parsing line #" + this.in.getLineNumber() + ", line reads:" + line);
                    continue;
                }
                if (this.processLogEntry(entry, line)) {
                    entries.add(entry);
                    continue;
                }
                System.err.println("problem in parsing this line:\n" + line);
            }
            catch (ParseException pe2) {
                String s = "Parse Exception in line #" + this.in.getLineNumber() + ":\n";
                s = s + pe2.getLocalizedMessage() + '\n';
                s = s + "Line: " + line + '\n';
                System.err.println(s);
                Object pe2 = null;
                entries.add(new LRCTFLogEntry(-1, this.in.getLineNumber(), 95, s));
            }
        }
        System.out.println();
        return entries;
    }

    public Vector pass2(List logEntries) {
        Vector<LRCTFMatch> matches = new Vector<LRCTFMatch>();
        while (!logEntries.isEmpty()) {
            LRCTFMatch match = new LRCTFMatch(logEntries);
            match.postParseEntries();
            if (match.isSane()) {
                matches.addElement(match);
                continue;
            }
            System.out.println("ERROR. Had to drop this match and all of its entries. Sorry.");
            PrintWriter peewee = new PrintWriter(System.out);
            match.printEntries(peewee);
            peewee.flush();
            peewee = null;
        }
        return matches;
    }
}

