/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.logs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LRCTFLogEntry
implements Serializable {
    private static int NUMENTRIES = 8;
    private static int D_KEY = 0;
    private static int D_MINUTE = 1;
    private static int D_SECOND = 2;
    public static int D_PLAYER = 3;
    public static int D_VICTIM = 4;
    public static int D_WEAPON = 5;
    public static int D_REASON = 3;
    public static int D_SCORE = 5;
    public static int D_PING = 4;
    public static int D_DEFENSE = 4;
    public static int D_OFFENSE = 5;
    public static int D_FRAGS = 6;
    public static int D_RED = 4;
    public static int D_BLUE = 5;
    public static int D_EX1 = 4;
    public static int D_EX2 = 5;
    public static int D_ITEMCODE = 4;
    private int[] data = new int[NUMENTRIES];
    private String otherText;

    public LRCTFLogEntry(int min, int sec, int key, String other) {
        this.data[LRCTFLogEntry.D_KEY] = key;
        this.data[LRCTFLogEntry.D_MINUTE] = min;
        this.data[LRCTFLogEntry.D_SECOND] = sec;
        this.otherText = other;
    }

    public String toString() {
        return this.data[D_MINUTE] + ":" + this.data[D_SECOND] + "\t#" + this.data[D_KEY] + " " + this.data[3] + " " + this.data[4] + " " + this.data[5] + " " + this.data[6] + " " + this.data[7] + " |" + this.otherText;
    }

    public final int getKey() {
        return this.data[D_KEY];
    }

    public final String getText() {
        return this.otherText;
    }

    public final String getTimeStamp() {
        return this.data[D_MINUTE] + ":" + this.data[D_SECOND];
    }

    public final int getMinute() {
        return this.data[D_MINUTE];
    }

    public final int getSecond() {
        return this.data[D_SECOND];
    }

    protected final void setText(String s) {
        this.otherText = s;
    }

    public int getData(int index) {
        if (index >= NUMENTRIES) {
            return -1;
        }
        return this.data[index];
    }

    public int[] getData() {
        return this.data;
    }

    public void setData(int index, int value) {
        if (index >= NUMENTRIES) {
            return;
        }
        this.data[index] = value;
    }

    public void setData(int[] src) {
        System.arraycopy(src, 0, this.data, 0, NUMENTRIES);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        for (int i = 0; i < NUMENTRIES; ++i) {
            out.writeInt(this.data[i]);
        }
        out.writeObject(this.otherText);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.data = new int[NUMENTRIES];
        for (int i = 0; i < NUMENTRIES; ++i) {
            this.data[i] = in.readInt();
        }
        this.otherText = (String)in.readObject();
    }
}

