/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.metabit.tools.games.lrctf.html.LROutputHelperHTML;
import org.metabit.tools.games.lrctf.stats.KeyToStatsItemMap;
import org.metabit.tools.games.lrctf.stats.PlayerStats;
import org.metabit.tools.games.lrctf.stats.Statistics;
import org.metabit.tools.games.lrctf.stats.StatsItem;
import org.metabit.tools.games.lrctf.stats.StatsItemCounter;
import org.metabit.tools.games.lrctf.stats.StatsItemTime;
import org.metabit.tools.games.lrctf.stats.TimeIntervalStats;

public class Statistics2HTMLConverter {
    static final String FILENAME_MAINPAGE = "index.html";
    static final String FILENAME_PLAYERPAGE = "players.html";
    private Statistics stats = null;
    private File outputDir = null;
    private File currentFile = null;
    private FileOutputStream fos = null;
    private PrintWriter out = null;

    public Statistics2HTMLConverter(File outputDirectory) throws IOException {
        this.outputDir = outputDirectory;
        if (!this.outputDir.exists()) {
            this.outputDir.mkdirs();
        }
        if (!this.outputDir.isDirectory()) {
            throw new IOException("outputDir is not a directory!");
        }
    }

    public void convertStatisticsToHTML(Statistics st) {
        this.stats = st;
        try {
            this.createMainPage();
            Iterator it = this.stats.iterator();
            while (it.hasNext()) {
                TimeIntervalStats tis = (TimeIntervalStats)it.next();
                System.out.println(tis.toString());
            }
            this.openAFile(FILENAME_PLAYERPAGE);
            this.out.println("<html><head><title>");
            this.out.print("LRCTF Statistics ");
            this.out.println(" - player stats");
            this.out.print("</title></head>");
            this.out.println("<body>");
            it = this.stats.iterator();
            while (it.hasNext()) {
                int numPlayers = 0;
                int numVisiblePlayers = 0;
                TimeIntervalStats tis = (TimeIntervalStats)it.next();
                this.out.println("</hr><h3>from " + tis.getIntervalStartDate() + " to " + tis.getIntervalEndDate() + "</h3>");
                this.out.println("<table>");
                this.out.println("<tr><th>name</th><th>time connected</th><th>matches played</th><th>kills</th><th>excellent!</th><th>captures</th><th>rail kill</th><th>rocket kill</th></tr>");
                Iterator pit = tis.getPlayerStatsIterator();
                while (pit.hasNext()) {
                    PlayerStats ps = (PlayerStats)pit.next();
                    if (ps.hasKills()) {
                        this.writePlayerStats(ps);
                        ++numVisiblePlayers;
                    }
                    ++numPlayers;
                }
                this.out.println("</table>");
                this.out.println("<div>overall " + numPlayers + " players in this interval, visible (>0 kills) of these: " + numVisiblePlayers + "</div>");
            }
            this.out.println("</body></html>");
            this.closeTheFile();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getLocalizedMessage());
            fnfe.printStackTrace(System.err);
            return;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getLocalizedMessage());
            ioe.printStackTrace(System.err);
            return;
        }
    }

    public void writePlayerStats(PlayerStats ps) {
        this.out.print("<tr><th align=left bgcolor=grey>");
        String pname = ps.getPrimaryName();
        if (pname != null) {
            this.out.print(LROutputHelperHTML.convertQ3ColoursToHTMLwithStyles(pname));
        } else {
            this.out.print("(nameless player)");
        }
        this.out.println("</th>");
        KeyToStatsItemMap psitems = ps.getStatsItemMap();
        String t = this.statsItemToString(ps.getItem(0));
        this.out.print("<td align=right>");
        this.out.print(t);
        this.out.print("</td>");
        t = this.statsItemToString(ps.getItem(1));
        this.out.print("<td align=right>");
        this.out.print(t);
        this.out.print("</td>");
        this.out.print("<td align=right>");
        this.out.print(this.getStatsItemString(psitems, 12));
        this.out.print("</td>");
        this.out.print("<td align=right>");
        this.out.print(this.getStatsItemString(psitems, 22));
        this.out.print("</td>");
        this.out.print("<td align=right>");
        this.out.print(this.getStatsItemString(psitems, 14));
        this.out.print("</td>");
        KeyToStatsItemMap wi = ps.getWeaponsMap();
        this.out.print("<td align=right>");
        this.out.print(this.getStatsItemString(wi, 10));
        this.out.print("</td>");
        this.out.print("<td align=right>");
        this.out.print(this.getStatsItemString(wi, 6));
        this.out.print("</td>");
        this.out.println("</tr>");
    }

    public String getStatsItemString(KeyToStatsItemMap map, int key) {
        StatsItem si = map.get(key);
        if (si == null) {
            return "0";
        }
        return this.statsItemToString(si);
    }

    public String statsItemToString(StatsItem si) {
        switch (si.getType()) {
            case 1: {
                StatsItemCounter sic = (StatsItemCounter)si;
                return Integer.toString(sic.getValue());
            }
            case 3: {
                StatsItemTime sit = (StatsItemTime)si;
                int numGamesPlayed = sit.getCount();
                if (numGamesPlayed == 0) {
                    return null;
                }
                long sekunden = sit.getSum();
                StringBuffer sb = new StringBuffer();
                long stunden = sekunden / 3600L;
                int minuten = (int)((sekunden - stunden * 3600L) / 60L);
                int restsek = (int)(sekunden % 60L);
                sb.append(stunden);
                sb.append("h ");
                sb.append(minuten);
                sb.append("m ");
                sb.append(restsek);
                sb.append("s");
                return sb.toString();
            }
        }
        return si.toString();
    }

    public void createMainPage() throws IOException {
        this.openAFile(FILENAME_MAINPAGE);
        this.out.println("<html><head><title>");
        this.out.print("LRCTF Statistics ");
        this.out.println(" - main page");
        this.out.print("</title></head>");
        this.out.println("<body>");
        this.out.println("statistics go here.");
        this.out.println("<hr/>=><a href=\"matches.html\">Matches</a>");
        this.out.println("<hr/>=><a href=\"players.html\">Players</a>");
        this.out.println("</body></html>");
        this.closeTheFile();
    }

    protected void openAFile(String filename) throws FileNotFoundException, IOException {
        this.currentFile = new File(this.outputDir, filename);
        this.currentFile.createNewFile();
        this.fos = new FileOutputStream(this.currentFile);
        this.out = new PrintWriter(this.fos);
    }

    protected void closeTheFile() throws IOException {
        if (this.out == null) {
            return;
        }
        this.out.close();
        this.out = null;
        System.gc();
        this.fos.close();
        this.fos = null;
        System.gc();
        long filesize = this.currentFile.length();
        this.currentFile = null;
        System.gc();
    }
}

