/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Vector;

public class LROutputHelperHTML {
    static final String Q3COLOURCHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@|<>()[]{}?!#:_,.-=\\/+$%^&*";
    static final String[] Q3HEXCOLOURCODES = new String[]{"000000", "ff1924", "a0b965", "f5f501", "4a54ea", "05ffff", "ff02fc", "FFFFFF", "7b00d5", "38cda5", "4601ef", "3ddd31", "dd5835", "354c80", "69b127", "01226f", "4cb02a", "98727d", "4dbee0", "97ae9e", "a6d77e", "aa83d6", "0bd67a", "df910b", "bdbeea", "00ff01", "e744b7", "293cd6", "45ec2c", "c84f35", "8649d8", "8ac9ac", "7f00b1", "22b8b6", "8dd600", "ae96e2", "30dbb9", "d79244", "b461a5", "87a8d3", "bb1080", "70c2d0", "92e154", "6a0e25", "374d7f", "5ccb24", "cdb78e", "a1bdd3", "ae32a4", "577b3d", "a36c71", "259364", "a29894", "b254aa", "280176", "690b25", "332089", "07d944", "000000", "000829", "1093bf", "b08537", "b58a2e", "7adc4b", "00fc02", "24b6ab", "e417e2", "01ffff", "3fad92", "24ba94", "b2150c", "30414b", "8cd746", "000000", "000000", "ccb8ad", "a42627", "7d827b", "614a82", "42433b", "92bea7", "a95d77", "2b0163", "c3c2bd", "ff1924", "5844b3", "5949a2", "0000f8", "ffffff"};
    static final String OPENC_A = "<font color=\"#";
    static final String OPENC_B = "\">";
    static final String CLOSE = "</font>";
    static /* synthetic */ Class class$org$metabit$tools$games$lrctf$html$LROutputHelperHTML;

    public static String getTextResourceAsString(String resname) {
        StringBuffer result = new StringBuffer();
        Class thisclass = class$org$metabit$tools$games$lrctf$html$LROutputHelperHTML == null ? (class$org$metabit$tools$games$lrctf$html$LROutputHelperHTML = LROutputHelperHTML.class$("org.metabit.tools.games.lrctf.html.LROutputHelperHTML")) : class$org$metabit$tools$games$lrctf$html$LROutputHelperHTML;
        String resourcename = resname.startsWith("/") ? resname : "phpcode/" + resname;
        try {
            String line;
            InputStream in = thisclass.getResourceAsStream(resourcename);
            if (in == null) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result.toString();
    }

    public static String[] fillInVariables(String template, Properties variables, String defaultstr) {
        int idx;
        StringBuffer result = new StringBuffer(template);
        Vector<String> fails = new Vector<String>();
        fails.addElement("");
        while ((idx = result.indexOf("${")) >= 0) {
            int idx2 = result.indexOf("}", idx);
            String key = result.substring(idx + 2, idx2);
            String value = variables.getProperty(key, null);
            if (value == null) {
                fails.addElement(key);
                value = defaultstr;
            }
            result.replace(idx, idx2 + 1, value);
        }
        Object[] failedVars = new String[fails.size()];
        fails.copyInto(failedVars);
        failedVars[0] = result.toString();
        return failedVars;
    }

    public static String[] generateFileFromTemplate(String templateResource, Properties variables, File directory, String filename, String defaultstring) throws IOException {
        String template = LROutputHelperHTML.getTextResourceAsString(templateResource);
        String[] result = LROutputHelperHTML.fillInVariables(template, variables, defaultstring);
        boolean isOK = true;
        if (result.length > 1) {
            return result;
        }
        File file = new File(directory, filename);
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(file);
        PrintWriter out = new PrintWriter(fos);
        out.print(result[0]);
        out.close();
        out = null;
        System.gc();
        fos.close();
        fos = null;
        System.gc();
        file = null;
        System.gc();
        return result;
    }

    public static String convertQ3ColoursToHTMLwithStyles(String q3text) {
        int currentColourID = -1;
        int len = q3text.length();
        StringBuffer result = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = q3text.charAt(i);
            if (c == '^') {
                if (++i >= len) break;
                c = q3text.charAt(i);
                int t = LROutputHelperHTML.getQ3ColourCodeNumber(c);
                if (t != currentColourID) {
                    if (currentColourID >= 0) {
                        result.append(LROutputHelperHTML.getQ3ColourMarkupStringClosing());
                        currentColourID = -1;
                    }
                    currentColourID = t;
                    result.append(LROutputHelperHTML.getQ3ColourMarkupStringOpening(currentColourID));
                    continue;
                }
                result.append("<!-- colour code ^" + c + " not recognised -->");
                continue;
            }
            result.append(c);
        }
        if (currentColourID >= 0) {
            result.append(LROutputHelperHTML.getQ3ColourMarkupStringClosing());
        }
        return result.toString();
    }

    static final String getQ3ColourMarkupStringOpening(int codeNum) {
        return OPENC_A + LROutputHelperHTML.getQ3ColourValuesByNumber(codeNum) + OPENC_B;
    }

    static final String getQ3ColourMarkupStringClosing() {
        return CLOSE;
    }

    static final int getQ3ColourCodeNumber(char codeChar) {
        if (codeChar == '*') {
            return -1;
        }
        return Q3COLOURCHARS.indexOf(codeChar);
    }

    static final String getQ3ColourValuesByNumber(int codeNum) {
        if (codeNum < Q3HEXCOLOURCODES.length) {
            return Q3HEXCOLOURCODES[codeNum];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

