/*
 * Decompiled with CFR 0.152.
 */
package org.metabit.tools.games.lrctf;

import com.metabit.naming.util.SimpleNameContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.metabit.tools.games.lrctf.Constants;

public class Config {
    public static final String CFGFILENAME = "./lrctfstats.cfg";
    boolean[] actions = null;
    SimpleNameContext commandlineCommands = null;
    ResourceBundle compiledDefaults = null;
    ResourceBundle settingsFromFile = null;

    public Config(String[] args) {
        if (this.commandlineCommands == null) {
            this.commandlineCommands = new SimpleNameContext();
            Constants.initCommandlineCommands(this.commandlineCommands);
        }
        if (this.actions == null) {
            this.actions = new boolean[this.commandlineCommands.getNumberOfEntries() + 1];
            for (int i = 0; i < this.actions.length; ++i) {
                this.actions[i] = false;
            }
        }
        try {
            this.compiledDefaults = PropertyResourceBundle.getBundle("org.metabit.tools.games.lrctf.defaultSettings");
            this.settingsFromFile = new PropertyResourceBundle(new FileInputStream(CFGFILENAME));
        }
        catch (MissingResourceException mre) {
        }
        catch (IOException ioe) {
            System.out.println("Note: you can set parameters for this program in the ./lrctfstats.cfg file.");
        }
        String defaultOptions = this.getString("options");
        StringTokenizer st = new StringTokenizer(defaultOptions, " ");
        int num = st.countTokens();
        if (num > 0) {
            String[] defaultCommandsArg = new String[num + 1];
            for (int i = 0; i < num && st.hasMoreTokens(); ++i) {
                defaultCommandsArg[i] = st.nextToken();
            }
            this.parseArgs(defaultCommandsArg);
        }
        this.parseArgs(args);
    }

    protected void parseArgs(String[] args) {
        block4: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.indexOf(61) > 0) continue;
            int cmdKey = this.commandlineCommands.lookupID(arg.toLowerCase().trim());
            switch (cmdKey) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.actions[cmdKey] = true;
                    continue block4;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.actions[0] = true;
                    continue block4;
                }
                default: {
                    System.err.println("command line option '" + arg + "' not recognised.");
                }
            }
        }
    }

    public boolean checkAction(int key) {
        if (key >= 0 && key < this.actions.length) {
            return this.actions[key];
        }
        return false;
    }

    public String[] getValidActions() {
        int num = this.commandlineCommands.getNumberOfEntries();
        String[] actionNames = new String[num + 1];
        for (int i = 0; i < num; ++i) {
            actionNames[i] = this.commandlineCommands.lookupName(i);
        }
        return actionNames;
    }

    public String getString(String key) {
        if (this.settingsFromFile != null) {
            try {
                return this.settingsFromFile.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (this.compiledDefaults != null) {
            return this.compiledDefaults.getString(key);
        }
        return null;
    }

    public String getString(String key, String defaultString) {
        String result = this.getString(key);
        return result == null ? defaultString : result;
    }

    public boolean getBoolean(String key) {
        String s = this.getString(key);
        if (s == null) {
            return false;
        }
        return Boolean.getBoolean(s);
    }
}

