/*
 * Decompiled with CFR 0.152.
 */
package com.metabit.naming.util;

import java.util.LinkedHashMap;

public class SimpleNameContext {
    public static final int ID_INVALID = -1;
    private boolean flag_locked = false;
    private LinkedHashMap storeID2Name;
    private LinkedHashMap storeName2ID;
    private int highestUsedID;

    public SimpleNameContext() {
        this.constructor();
    }

    public void finalize() {
        this.destructor();
    }

    public final int lookupID(String name) {
        return this.findIDByName(name);
    }

    public final String lookupName(int ID) {
        return this.findNameByID(ID);
    }

    public int getOrAddString(String name) {
        if (this.flag_locked) {
            return -1;
        }
        return this.put(name);
    }

    public boolean putPair(String name, int id) {
        return this.put(name, id);
    }

    public void lock() {
        this.flag_locked = true;
    }

    public void unlock() {
        this.flag_locked = false;
    }

    public int getNumberOfEntries() {
        return this.getNumEntries();
    }

    private void constructor() {
        this.storeID2Name = new LinkedHashMap();
        this.storeName2ID = new LinkedHashMap();
        this.highestUsedID = 0;
    }

    private void destructor() {
        this.storeID2Name.clear();
        this.storeName2ID.clear();
        this.storeID2Name = null;
        this.storeName2ID = null;
    }

    private synchronized Integer generateNewID() {
        Integer id;
        while (this.storeID2Name.containsKey(id = new Integer(++this.highestUsedID))) {
        }
        return id;
    }

    private int findIDByName(String name) {
        Object o = this.storeName2ID.get(name);
        if (o == null) {
            return -1;
        }
        Integer i = (Integer)o;
        return i;
    }

    private String findNameByID(int id) {
        Object o = this.storeID2Name.get(new Integer(id));
        if (o == null) {
            return null;
        }
        return (String)o;
    }

    private int put(String name) {
        if (this.storeName2ID.containsKey(name)) {
            return this.findIDByName(name);
        }
        Integer id = this.generateNewID();
        this.storeName2ID.put(name, id);
        this.storeID2Name.put(id, name);
        return id;
    }

    private boolean put(String name, int id) {
        Integer idObj = new Integer(id);
        if (this.storeID2Name.containsKey(new Integer(id))) {
            return name.compareTo(this.storeID2Name.get(idObj)) == 0;
        }
        if (this.storeName2ID.containsKey(name)) {
            return false;
        }
        this.storeName2ID.put(name, idObj);
        this.storeID2Name.put(idObj, name);
        return true;
    }

    private int getNumEntries() {
        return this.storeID2Name.size();
    }
}

